<?php


/**
  Module developed for the Open Source Content Management System Website Baker (http://websitebaker.org)
  Copyright (C) 2007, Christian Thamer
  Contact me: christian(at)thamer.net, http://www.thamer.net

  This module is free software. You can redistribute it and/or modify it 
  under the terms of the GNU General Public License  - version 2 or later, 
  as published by the Free Software Foundation: http://www.gnu.org/licenses/gpl.html.

  This module is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
  GNU General Public License for more details.
**/

// prevent this file from being accesses directly
if(defined('WB_PATH') == false) {
	exit("Cannot access this file directly"); 
}
require_once(WB_PATH.'/framework/functions.php');


// check if module language file exists for the language set by the user (e.g. DE, EN)
if(!file_exists(WB_PATH .'/modules/fancybraxbox_B/languages/' .LANGUAGE .'.php')) {
	// no module language file exists for the language set by the user, include default module language file EN.php
	require_once(WB_PATH .'/modules/fancybraxbox_B/languages/EN.php');
} else {
	// a module language file exists for the language defined by the user, load it
		require_once(WB_PATH .'/modules/fancybraxbox_B/languages/' .LANGUAGE .'.php');
}

/**
*	INLCUDE BACKEND.CSS INTO THE HTML BODY OF THE PAGE IF WB < 2.6.6
*	NOTE: THIS WAY MODULES BECOME DOWNWARD COMPATIBLE WITH OLDER WB RELEASES
*/
// check if backend.css file needs to be included into the <body></body> of modify.php
if(!method_exists($admin, 'register_backend_modfiles') && file_exists(WB_PATH .'/modules/fancybraxbox_B/backend.css')) {
	echo '<style type="text/css">';
	include(WB_PATH .'/modules/fancybraxbox_B/backend.css');
	echo "\n</style>\n";
}

// obtain data from module DB-table of the current displayed page (unique page defined via section_id)
$sql_result = $database->query("SELECT * FROM " .TABLE_PREFIX ."mod_fancybraxbox_B WHERE section_id = '$section_id'");

// store all results (fields) in the array $sql_row
$sql_row = $sql_result->fetchRow();

// check if the DB-Field gallery_path contains a value, if not use /media/gallery/ as default value.
if ($sql_row['gallery_path'] == "/" || $sql_row['gallery_path'] == "") {
	$sql_row['gallery_path'] = '/media/'; 
} else {
	// Note: before displaying a string in a text field, one needs to convert all special characters into entities
	// otherwise characters like ", \ not converted into entities will not show up in text fields, even if they are in the DB
	// this measure also prevents that Javascript/PHP Code and tags are parsed by the browser.
	$sql_row['gallery_path'] = htmlspecialchars($sql_row['gallery_path']);
}
// check if the DB-Field gallery_path contains a value, if not use /media/gallery/ as default value.
if ($sql_row['thumb_path'] == "/" || $sql_row['thumb_path'] == "") {
	$sql_row['thumb_path'] = '/media/thumbs/'; 
} else {
	$sql_row['thumb_path'] = htmlspecialchars($sql_row['thumb_path']);
}

// create the form with text outputs and buttons below using mixed HTML and PHP code
?>
<style type="text/css">
.lb_footnotes {
 	margin: 25px 0 25px 0;
 }
.lb_table{
	padding: 2px;
	border: 2px solid #fff;
 }
.lb_input_type {
	background-color: #9999FF;
	border: 2px solid #fff;
}
</style>


<?php
// create CSS editing section
if (isset($_POST['edit_css'])) {
	$file = WB_PATH.'/modules/fancybraxbox_B/frontend.css';
	if (strlen($file)>2) {   // Make sure $file is valid before showing, prevents rubbish
		$fp = @fopen($file, "r");
		$fileread = fread($fp, filesize($file));
		$fileread = htmlspecialchars($fileread);
		fclose($fp);
		?> 
		<h2><?php echo $MOD_LIGHTBOX2['EDIT_FRONTENDCSS']; ?></h2>
		<form method="post" action="<?php echo WB_URL; ?>/modules/fancybraxbox_B/css_save.php">
		<textarea name="savecontent" cols="120" rows="25"><?php echo $fileread; ?></textarea>
		<table cellpadding="0" cellspacing="0" border="0" width="100%">
			<tr>
				<td align="left">
					<input type="hidden" name="file" value="<?php echo $file; ?>"> 
					<input type="hidden" name="page_id" value="<?php echo $page_id; ?>"> 
					<input type="submit" name="save_file" value="<?php echo $MOD_LIGHTBOX2['SAVE_FRONTENDCSS']; ?>" style="width: 150px; margin-top: 5px;"/></form>
				</td>
				<td align="right">
					<form action="<?php echo $_SERVER['PHP_SELF'];?>?page_id=<?php echo $page_id; ?>" method="post">
					<input type="submit" name="return" value="<?php echo $MOD_LIGHTBOX2['BACK_FRONTENDCSS']; ?>" style="width: 150px; margin-top: 5px;"/></form>
				</td>
			</tr>
		</table>
	<?php
	} else { 
		echo $MOD_LIGHTBOX2['ERROR_FRONTENDCSS'];?>&nbsp;<?php $file;  
	}
} else {
 // output main modify section
 	?>

	<form action="<?php echo WB_URL; ?>/modules/fancybraxbox_B/save.php" method="post" name="settings">
	<input name="page_id" value="<?php echo $page_id; ?>" type="hidden">
	<input name="section_id" value="<?php echo $section_id; ?>" type="hidden">
	<table width="90%" class="lb_table" border="0" cellspacing="0" cellpadding="0">
	  <tr>
	  	<td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['GALLERY_NAME_OPT']; ?></td>
	  	<td><input type="text" name="gallery_name" value="<?php echo $sql_row['gallery_name']; ?>" /></td>
	    <td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['GALLERY_PATH']; ?></td>
	    <td><input type="text" name="gallery_path" size=30 value="<?php echo $sql_row['gallery_path']; ?>" /></td>
	  </tr>
	  <tr>
	    <td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['COLUMS']; ?></td>
	    <td><input type="text" name="num_columns" size=10 value="<?php echo $sql_row['image_columns']; ?>" /></td> 
	    <td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['THUMBNAIL_PATH']; ?></td>
	    <td><input type="text" name="thumb_path" size=30 value="<?php echo $sql_row['thumb_path']; ?>" /></td>
	  </tr>
	  <tr>
	  	<td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['ROWS']; ?></td>
	    <td><input type="text" name="num_rows" size=10 value="<?php echo $sql_row['image_rows']; ?>" /></td>
	    <td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['THUMBNAIL_WIDTH_PIX']; ?></td>
	    <td><input type="text" name="thumb_width" size=10 value="<?php echo $sql_row['thumb_width']; ?>" /></td>    
	  </tr>
	  <tr>
	    <td class="lb_input_type"><?php echo $MOD_LIGHTBOX2['IMAGE_MAX_WIDTH']; ?></td>
	    <td><input type="text" name="max_width" size=10 value="<?php echo $sql_row['max_width']; ?>" /></td>
	    <td><input name="save" type="submit" value="<?php echo $MOD_LIGHTBOX2['SUBMIT']; ?>" style="width: 100px; margin-top: 5px;"></form></td>
	    <td><input type="button" value="<?php echo $MOD_LIGHTBOX2['CANCEL']; ?>" onclick="javascript: window.location = '<?php echo ADMIN_URL; ?>/pages/index.php'; return false;" style="width: 100px; margin-top: 5px;" /></td>
	  </tr>
	</table>
	</form>
	<div class="lb_footnotes">
	<?php echo $MOD_LIGHTBOX2['THUMBNAIL_FOOTNOTE']; ?><br />
	<?php echo $MOD_LIGHTBOX2['IMAGE_MAX_WIDTH_FOOTNOTE']; ?></div>	

	<form name="css" action="<?php echo $_SERVER['PHP_SELF']; ?>?page_id=<?php echo $page_id; ?>" method="post">
	<table id="lightbox_table">
		<tr>
			<td class="lb_input_type">
				<?php echo $MOD_LIGHTBOX2['EDIT_CSS_LABEL']; ?>
			</td>
			<td align="right">
				<input name="edit_css" type="submit" value="<?php echo $MOD_LIGHTBOX2['CSS_MODIFY']; ?>" style="width: 150px;"/>
			</td>
		</tr>
	</table>
	</form>
		<div class="lb_footnotes">
	<?php echo $MOD_LIGHTBOX2['EDIT_CSS_FOOTNOTE']; ?></div>	
<?php } ?>